/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.lib;

import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.json4s.Formats;
import org.json4s.native.Serialization$;
import rpgboss.model.RpgMapData$;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$FloatIsFractional$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichFloat$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public int ceilIntDiv(int n, int m) {
        return (n - 1) / m + 1;
    }

    public int ceilFloatDiv(float n, int m) {
        return this.ceilIntDiv((int)RichFloat$.MODULE$.ceil$extension(Predef$.MODULE$.floatWrapper(n)), m);
    }

    public int clamped(int orig, int min2, int max2) {
        Predef$.MODULE$.assume(max2 >= min2);
        return package$.MODULE$.min(max2, package$.MODULE$.max(min2, orig));
    }

    public float clamped(float orig, float min2, float max2) {
        Predef$.MODULE$.assume(max2 >= min2);
        return package$.MODULE$.min(max2, package$.MODULE$.max(min2, orig));
    }

    public int pmod(int x, int m) {
        return (x % m + m) % m;
    }

    public <T> T randomChoose(Object items, float[] weights) {
        Object object = new Object();
        try {
            Predef$.MODULE$.assume(!Predef$.MODULE$.genericArrayOps(items).isEmpty());
            Predef$.MODULE$.assume(!Predef$.MODULE$.floatArrayOps(weights).isEmpty());
            Predef$.MODULE$.assume(ScalaRunTime$.MODULE$.array_length(items) == weights.length);
            float total2 = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatArrayOps(weights).sum(Numeric$FloatIsFractional$.MODULE$));
            float roll = Random$.MODULE$.nextFloat() * total2;
            FloatRef cumProb = FloatRef.create(0.0f);
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(items).zip(Predef$.MODULE$.wrapFloatArray(weights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter(new Serializable(){

                public final boolean apply(Tuple2<T, Object> check$ifrefutable$1) {
                    Tuple2<T, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach(new Serializable(roll, cumProb, object){
                private final float roll$1;
                private final FloatRef cumProb$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(Tuple2<T, Object> x$4) {
                    Tuple2<T, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        T item = tuple2._1();
                        float weight = BoxesRunTime.unboxToFloat(tuple2._2());
                        this.cumProb$1.elem += weight;
                        if (this.roll$1 < this.cumProb$1.elem) {
                            throw new NonLocalReturnControl<T>(this.nonLocalReturnKey1$1, item);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.roll$1 = roll$1;
                    this.cumProb$1 = cumProb$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            Predef$.MODULE$.assert(false);
            return (T)Predef$.MODULE$.genericArrayOps(items).head();
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public boolean randomWithPercent(int chance) {
        Predef$.MODULE$.assert(chance >= 0);
        Predef$.MODULE$.assert(chance <= 100);
        return Random$.MODULE$.nextInt(100) < chance;
    }

    public String floatToPercent(float x) {
        return new StringOps(Predef$.MODULE$.augmentString("%d%%")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(x * (float)100)))}));
    }

    public <T> Seq<T> removeFromSeq(Seq<T> seq, int i) {
        return ((TraversableLike)seq.take(i)).$plus$plus((GenTraversableOnce)seq.drop(i + 1), Seq$.MODULE$.canBuildFrom());
    }

    public BufferedImage readClasspathImage(String path2) {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(path2);
        if (resource == null) {
            throw new RuntimeException(new StringBuilder().append((Object)"Could not load: ").append((Object)path2).toString());
        }
        return ImageIO.read(resource);
    }

    public long copyResource(String resourcePath, File targetFile) {
        ByteSource source = Resources.asByteSource(Resources.getResource(resourcePath));
        return source.copyTo(Files.asByteSink(targetFile, new FileWriteMode[0]));
    }

    public <A> A deepCopy(A a, Manifest<A> m) {
        return this.deepCopyWithFormats(a, RpgMapData$.MODULE$.formats(), m);
    }

    private <A> A deepCopyWithFormats(A a, Formats formats, Manifest<A> m) {
        String json = Serialization$.MODULE$.write(a, formats);
        return Serialization$.MODULE$.read(json, formats, m);
    }

    public String generateFilename(String prefix, int id, String ext) {
        return new StringOps(Predef$.MODULE$.augmentString("%s%06d.%s")).formatLocal(Locale.US, Predef$.MODULE$.genericWrapArray(new Object[]{prefix, BoxesRunTime.boxToInteger(id), ext}));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

